#include <algorithm>
#include <iostream>
#include <set>

#define sqr(a) ((a) * (a))


void printResult(const std::set<int> &set) {
    std::cout << set.size() << std::endl;
    for (auto it = set.begin(); it != set.end(); ++it) {
        if (it != set.begin()) std::cout << ' ';
        std::cout << *it + 1;
    }
}

int main(int argc, char *argv[]) {
    int count;
    std::cin >> count;

    std::set<int> setA;
    std::set<int> setB;
    std::set<int> setC;
    std::set<int> setD;

    std::pair<int, int> diffA;
    std::pair<int, int> diffB;
    std::pair<int, int> diffC;
    std::pair<int, int> diffD;

    for (int i = 0; i < count; i++) {
        int x, y;
        std::cin >> x >> y;
        if (x > 0 && y > 0) {
            setA.insert(i);
            diffA.first += x;
            diffA.second += y;
        } else if (x < 0 && y > 0) {
            setB.insert(i);
            diffB.first += x;
            diffB.second += y;
        } else if (x < 0 && y < 0) {
            setC.insert(i);
            diffC.first += x;
            diffC.second += y;
        } else if (x > 0 && y < 0) {
            setD.insert(i);
            diffD.first += x;
            diffD.second += y;
        }
    }

    int squaredDists[15];

    for (int i = 1; i < 16; i++) {
        const int val1 = sqr((i % 2) * diffA.first + (i/2 % 2) * diffB.first + (i/4 % 2) * diffC.first + (i/8 % 2) * diffD.first);
        const int val2 = sqr((i % 2) * diffA.second + (i/2 % 2) * diffB.second + (i/4 % 2) * diffC.second + (i/8 % 2) * diffD.second);
        squaredDists[i-1] = val1 + val2;
    }

    const int *squaredDistMax = std::max_element(squaredDists, squaredDists + 15);

    for (int i = 1; i < 16; i++) {
        if (*squaredDistMax == squaredDists[i-1]) {
            std::set<int> resultSet;
            if (i % 2) resultSet.merge(setA);
            if (i/2 % 2) resultSet.merge(setB);
            if (i/4 % 2) resultSet.merge(setC);
            if (i/8 % 2) resultSet.merge(setD);
            printResult(resultSet);
            return 0;
        }
    }
}